unit ComponentForm;

//     
//  RunTime.     
//(TControlClass = class of TControl)    .

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, ComCtrls;

type  
  TForm1 = class(TForm)
    Panel1: TPanel;
    CbBoxControl: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}

//  class reference type (redeclaration)
type  TControlClass = class of TControl;

//    RunTime  
const ArrCtrl : array [0..7] of
  record
    RqW   : boolean;       //    
    RqH   : boolean;       //    
    CRef  : TControlClass  //    
  end =
    ((RqW : True;  RqH : False; CRef : TLabel),
     (RqW : True;  RqH : False; CRef : TEdit),
     (RqW : True;  RqH : True;  CRef : TMemo),
     (RqW : True;  RqH : True;  CRef : TButton),
     (RqW : False; RqH : False; CRef : TCheckBox),
     (RqW : False; RqH : False; CRef : TRadioButton),
     (RqW : True;  RqH : True;  CRef : TListBox),
     (RqW : True;  RqH : False; CRef : TComboBox)
    );

const MinW = 10;          //     
      MinH = 5;           //     

//  
var XB, YB   : integer;    //     
    XE, YE   : integer;    //     
    Counter  : Integer;    //   
    FElastic : boolean;    //  -    
    FMoveYes : boolean;    //  -     

// DynamicComponent:
//    RqInd   ArrCtrl .
//       
// (XB, YB, XE, YE)     . RqOwner -  
//   ()   .
//    ,  - Form1

procedure DynamicComponent(RqInd   : integer;
                           RqOwner : TWinControl);
var
  CRef    : TControlClass;  //     
  DynCtrl : TControl;       //    
  CName   : String;         //     
begin
      //    
      CRef := ArrCtrl[RqInd].CRef;
      //       
      //    (   Form1)
      DynCtrl := CRef.Create(RqOwner);
      //      
      DynCtrl.Visible := False;
      //    
      DynCtrl.Parent := RqOwner;
      //   
      DynCtrl.Left   := XB;
      DynCtrl.Top    := YB;
      if ArrCtrl[RqInd].RqW then DynCtrl.Width  := XE - XB;
      if ArrCtrl[RqInd].RqH then DynCtrl.Height := YE - YB;
      //    
      Counter := Counter + 1;
      //    
      CName := 'Dynamic' + IntToStr (Counter) + CRef.ClassName;
      DynCtrl.Name := CName;
      //  
      DynCtrl.Visible := True;
end;

//   
procedure TForm1.FormCreate(Sender: TObject);
var Ind : integer;
begin
   //      
   FElastic := False;
   //    
   CbBoxControl.Clear;
   for Ind := Low(ArrCtrl) to High(ArrCtrl)
   do CbBoxControl.Items.Add(ArrCtrl[Ind].CRef.ClassName);
   CbBoxControl.ItemIndex := 0;
end;

//     (  )
procedure TForm1.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   //     
   XB := X;
   YB := Y;
   //     
   Canvas.Pen.Color := clBlack;
   Canvas.Brush.Style := bsClear;
   //        
   // (   )
   Canvas.Pen.Mode := pmNotXor;
   //   -    , 
   //       
   FMoveYes := False;
end;

//
procedure TForm1.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
 if Canvas.Pen.Mode = pmNotXor
 then begin
   //      
   if (XB <> X) or (YB <> Y)
   then begin
      //     XB, YB
      if FElastic
      then //   
           Canvas.Rectangle(XB,YB,XE,YE)
      else FElastic := True;
      //   
      Canvas.Rectangle(XB,YB,X,Y);
      //    
      XE := X;
      YE := Y;
      //     
      //   
      FMoveYes := True;
   end;
 end;
end;

//     (  )
//   
procedure TForm1.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   //      ,    
   if FMoveYes then Canvas.Rectangle(XB,YB,XE,YE);
   FMoveYes := False;
   //     
   Canvas.Pen.Mode := pmCopy;
   FElastic := False;
   //   (MouseUp)   
   XE := X;
   YE := Y;
   //    ,   
   if (XE - XB > MinW) and (YE - YB > MinH)
   then begin
      DynamicComponent(CbBoxControl.ItemIndex, Form1);
   end
   else ShowMessage ('  .  :'
                     + #13 + ' > ' + IntToStr(MinW)
                     + #13 + ' > ' + IntToStr(MinH)
                    );
end;

end.
